package chess4j.io;

import chess4j.App;
import chess4j.Color;
import chess4j.board.Board;
import chess4j.utils.GameStatus;

public class PrintGameResult {

	public static void printResult(GameStatus gs) {
		Board b = App.getBoard();
		if (GameStatus.CHECKMATED.equals(gs)) {
			if (b.getPlayerToMove().equals(Color.WHITE)) {
				System.out.println("RESULT 0-1 {Black mates}\n");
			} else {
				System.out.println("RESULT 1-0 {White mates}\n");
			}
		} else if (GameStatus.STALEMATED.equals(gs)) {
			System.out.println("RESULT 1/2-1/2 {Stalemate}\n");
		} else if (GameStatus.DRAW_MATERIAL.equals(gs)) {
			System.out.println("RESULT 1/2-1/2 {Draw by lack of mating material}\n");
		} else if (GameStatus.DRAW_BY_50.equals(gs)) {
			System.out.println("RESULT 1/2-1/2 {Draw by 50 move rule}\n");
		} else if (GameStatus.DRAW_REP.equals(gs)) {
			System.out.println("RESULT 1/2-1/2 {Draw by repetition}\n");
		}
	}
}
